#include "map.hpp"

int load_map(MAP* map,char* name)
{
    if(exists(name) == 0)
    return -1;
    push_config_state();
    set_config_file(name);
    int num_objects = get_config_int("MAIN", "objects", -1);
    if(num_objects < 0)
    return -2;
    char prefix[] = "object-";
    char s_copy[100];
    char number[100];
    object temp;
    for(int i = 0; i <= num_objects; i++)
    {
        strcpy(s_copy, prefix);
        strcat(s_copy,itoa(i+1,number,10));
        temp.type = get_config_int(s_copy, "type", -1);  
        if(temp.type == -1)
        break;
        temp.x = get_config_int(s_copy, "x", -1);
        temp.y = get_config_int(s_copy, "y", -1);
        temp.h = get_config_int(s_copy, "h", -1);
        temp.w = get_config_int(s_copy, "w", -1); 
        temp.solid =  get_config_int(s_copy, "solid", 0); 
        temp.playerx = get_config_int("MAIN", "playerx", -1);
        temp.playery = get_config_int("MAIN", "playery", -1);
        temp.text=get_config_int(s_copy,"text",0);
        map->objects.push_back(temp);
    }
    pop_config_state();
    return 0;
};
